<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
    <%@page import="java.util.*"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
	<title>MyLiveChat Integration Basic Encryption Mode Demo</title>
    <style type="text/css">
        html,body {margin:0px; padding:0px;}
        body {background:#eeeeee; font-family:MS Sans Serif; font-size:13px;}
        
        .section {font-weight:bold;}
        ul { list-style-type:decimal;}
        ul div {margin-top:10px;}
    </style>
</head>
<body>
<%!
//My LiveChat Id
String MyLiveChatID = "92252608";
String UserName = "test user";
String UserKey = "test key";

//The encrypt key should be the same as setting on mylivechat account console.
String UserKeyEncryptBasicKey = "mytestkey";
String UserKeyEncryptMode = "Basic";

public String GetEncrypt(String str)
{
    if (UserKeyEncryptMode == "Basic")
    {
    	str = BasicEncrypt(UserKey, UserKeyEncryptBasicKey); 
    }
    return str;
}

//region MyLiveChat Encrypt Algorithm
int EncryptLoopCount = 4;
public int[] MakeArray(String str, Boolean random)
{
    int len = (int)Math.pow(2, Math.floor(Math.log(2)/Math.log(str.length())) + 1) + 8;
    if (len < 32) len = 32;

    int[] arr = new int[len];

    if (random)
    {
        Random r = new Random();
        for (int i = 0; i < arr.length; i++)
            arr[i] = str.charAt(r.nextInt(9999) % str.length());

        int start = 1 + r.nextInt(9999) % (len - str.length() - 2);

        for (int i = 0; i < str.length(); i++)
            arr[start + i] = str.charAt(i);

        arr[start - 1] = 0;
        arr[start + str.length()] = 0;
    }
    else
    {
        for (int i = 0; i < arr.length; i++)
            arr[i] = str.charAt(i % str.length());
    }

    return arr;
}

public String BasicFormat(int[] vals)
{
    StringBuilder sb = new StringBuilder();
    for (int i=0;i<vals.length;i++)
    {
        if (sb.length() > 0)
            sb.append("-");
        sb.append(vals[i]);
    }
    return sb.toString();
}

public String BasicEncrypt(String data, String encryptkey)
{
    if (data==null || data.trim() == "")
        throw new IllegalArgumentException("data");
    if (encryptkey == null || encryptkey == "")
        throw new IllegalArgumentException("encryptkey");

    int[] vals = MakeArray(data, true);
    int[] keys = MakeArray(encryptkey, false);

    for (int t = 0; t < EncryptLoopCount; t++)
    {
        for (int i = 0; i < vals.length; i++)
        {
            int v = vals[i];
            int im = (v + i) % 5;

            for (int x = 0; x < vals.length; x++)
            {
                if (x == i)
                    continue;
                if (x % 5 != im)
                    continue;

                for (int y = 0; y < keys.length; y++)
                {
                    int k = keys[y];
                    if (k == 0)
                        continue;

                    vals[x] += v % k;
                }
            }
        }
    }
    return BasicFormat(vals);
}
%>
 <div style="text-align:center;">
        <div style="width:800px; margin:auto; margin-top:20px; padding:10px; border:1px solid #dbdbdb; text-align:left; background:white;">
        <h3>
            MyLiveChat Integration Basic Encryption Mode Demo for C#
        </h3>
        <div>
            <ul>
                <li>
                    <div class="section">Config MyLiveChat Integration Settings</div>
                    <div>
                        Login to MyLiveChat, and go to Account Console.
                        Click <b>Advanced Topics -> Integration</b> Settings menu on the left.
                        <br /><br />
                        Select Basic mode, input an encryption key you used in this demo.
                        <p>
                            <img src="images/img_1.gif" alt="img 1" />
                        </p>
                    </div>
                </li>
                <li>
                    <div class="section">Encrypt user key, insert MyLiveChat code, set user key by MyLiveChat javascript API</div>
                    <div style="padding:3px; border:solid 1px #dddddd;">                        
                        <span style='color:#009900; '>&lt;!--This is mylivechat html code--></span>
                        <br />
                        <span style='color:#0000FF; '>&lt;</span><span style='color:#800000; font-weight:bold; '>script</span> <span style="color: #FF0000">type</span><span style="color: #0000CC">="text/javascript"</span>
                            <span style="color: #FF0000">src</span><span style="color: #0000CC">="https://www.mylivechat.com/chatbutton.aspx?hccid=</span><span style="color: #CC0000">MyLiveChatID</span><span style="color: #0000CC">"</span><span style='color:#0000FF; '>&gt;</span>
                        <span style='color:#0000FF; '>&lt;/</span><span style='color:#800000; font-weight:bold; '>script</span><span style='color:#0000FF; '>&gt;</span>
                        <br />
                        <span style='color:#0000FF; '>&lt;</span><span style='color:#800000; font-weight:bold; '>script</span> <span style="color: #FF0000">type</span><span style="color: #0000CC">="text/javascript"</span><span style='color:#0000FF;'>&gt;</span>
                        <br />
						function MyLiveChat_OnInit() { <br/>
                        &nbsp;&nbsp;&nbsp;&nbsp;MyLiveChat_SetUserName("USERNAME", "USERKEY");
                        <br />
						} <br/>
                        <span style='color:#0000FF; '>&lt;/</span><span style='color:#800000; font-weight:bold; '>script</span><span style='color:#0000FF; '>&gt;</span>
                        
                    </div>
                </li>
                <li>
                    <div class="section">Test</div>
                    <div>
                        <script type="text/javascript"src="https://www.mylivechat.com/chatbutton.aspx?hccid=<%=MyLiveChatID %>"></script>
                        <script type="text/javascript">
						function MyLiveChat_OnInit() {
                            MyLiveChat_SetUserName("<%=UserName %>", "<%=GetEncrypt(UserKey) %>");
						}
                        </script>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    </div>
</body>
</html>